﻿Function Get-NetworkAdapterIndices
{
    $indices=@()
    $netAdapters=Get-WmiObject -Query "SELECT * FROM Win32_NetworkAdapter Where NOT PnpDeviceId LIKE 'ROOT%' AND NOT PnpDeviceId LIKE 'SW%' AND NOT PnpDeviceId LIKE 'BTH%'"
    foreach ($netAdapter in $netAdapters)
    {
        $indices+=("$($netAdapter.DeviceId)").PadLeft(4,'0')
    }
    return $indices
}

Function Get-USBHubDeviceIds
{
    $deviceIds=@()
    $usbControllers=Get-WmiObject -Class Win32_USBController
    foreach ($usbController in $usbControllers)
    {
        #Find the associated hubs....
        $pnpId=($usbController.PnpDeviceId).Replace("\","\\")
        $wql="associators of {Win32_USBController.DeviceID=`"$pnpId`"} Where ResultClass=Win32_USBHub"
        $hubs=Get-WmiObject -Query $wql
        if($hubs -ne $null)
        {
            foreach($hub in $hubs)
            {
                $deviceIds+=$hub.PnpDeviceId
            }
        }
    }
    return $deviceIds
}

Function Stop-NetworkPowerSuspend
{
    $networkIndices=Get-NetworkAdapterIndices
    foreach ($networkIndex in $networkIndices)
    {
        $keyName="HKLM:\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}\$networkIndex"
        [void](New-ItemProperty -Path $keyName -Name "PnPCapabilities" -Value 24 -PropertyType "DWORD" -Force)
        Write-Host "Disabled Suspend For Network Adapter Index:$networkIndex"
    }
}

Function Stop-USBSelectiveSuspend
{
    $usbDeviceIds=Get-USBHubDeviceIds
    foreach ($usbDeviceId in $usbDeviceIds)
    {
        $keyName="HKLM:\SYSTEM\CurrentControlSet\Enum\$usbDeviceId\Device Parameters"
        [void](New-ItemProperty -Path $keyName -Name "EnableSelectiveSuspend" -Value 0 -PropertyType "DWORD" -Force)
        Write-Host "Disabled Suspend For USB Hub DeviceId:$usbDeviceId"
    }
}

Start-Transcript -Path "$env:TEMP\redbox-disablesuspend.log" -Append

Write-Host "Disabling Suspend on Network Adapters..."
Stop-NetworkPowerSuspend

Write-Host "Disabling Suspend on USB Controllers..."
Stop-USBSelectiveSuspend

Stop-Transcript|Out-Null